import Utilities.waveform_creator as wc
import Utilities.gui_creator as gc
import Utilities.plot_creator as pc
import Utilities.nidaq_operations as no
import threading

channel_name = 'Dev1/ai0:1'
trig_pin = '/Dev1/PFI0'
task = no.create_ai_task(channel_name)

title='Dual-Channel Digital Oscilloscope'
label_x, label_y = 'Time (ms)','Voltage (V)'

root = gc.create_window(title)
control_box,right_frame = gc.create_frames(root)

var_num, var_samp_freq = gc.digitizing_control(control_box)
var_trig = gc.trigger_control(control_box)

ax, canvas = pc.create_plot(right_frame)
pc.update_plot(ax, canvas, [], [], label_x, label_y)

def acquire_waveform():

    while btn.cget('text') == 'Stop':

        num,samp_freq = gc.get_dig_entries(var_num,
                                            var_samp_freq)
        edge_option = gc.get_edge_option(var_trig)

        no.config_daq_timing(task,num, 'Finite', samp_freq)
        no.config_daq_triggering(task,trig_pin, edge_option)

        t = wc.create_time_data(num,samp_freq)
        y = task.read(num)

        pc.update_two_curve_plot(ax, canvas, 1000*t, y[0], y[1], label_x, label_y,
                          marker='-')

    return


def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text='Stop')
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')

    t = threading.Thread(target=acquire_waveform)
    t.start()

    return

btn = gc.action_button(control_box, label='Start',
                       action=toggle)

root.mainloop()

task.close()
